(in-package :maxima)

(defprop ASINH "\\argsh" texword)
(defprop ACOSH "\\argch" texword)
(defprop ATANH "\\argth" texword)
(defprop INFINITY "\\infty" texword)

(defun tex-mquotient (x l r)
  (if (or (null (cddr x)) (cdddr x)) (wna-err (caar x)))
  (setq l (tex (cadr x) (append l '("\\frac{")) nil 'mparen 'mparen)
	;the divide bar groups things
	r (tex (caddr x) (list "}{") (append '("}")r) 'mparen 'mparen))
  (append l r))

(defprop $matrix tex-matrix tex)

(defun tex-matrix(x l r) ;;matrix looks like ((mmatrix)((mlist) a b) ...)
  (append l `("\\begin{pmatrix}")
	 (mapcan #'(lambda(y)
			  (tex-list (cdr y) nil (list "\\\\[1mm] ") "&"))
		 (cdr x))
	 '("\\end{pmatrix}") r))

(defun tex-int (x l r)
  (let ((s1 (tex (cadr x) nil nil 'mparen 'mparen));;integrand delims / & d
	(var (tex (caddr x) nil nil 'mparen rop))) ;; variable
       (cond((= (length x) 3)
	     (append l `("\\int {" ,@s1 "}{\\;\\mathrm{d}" ,@var "}") r))
	    (t ;; presumably length 5
	       (let ((low (tex (nth 3 x) nil nil 'mparen 'mparen))
		     ;; 1st item is 0
		     (hi (tex (nth 4 x) nil nil 'mparen 'mparen)))
		    (append l `("\\int_{" ,@low "}^{" ,@hi "}{" ,@s1 "\\;\\mathrm{d}" ,@var "}") r))))))

